/*:
@plugindesc MZ modifications for my own personal use. You probably don't want to use this in your own project.
@author scummbag
@target MZ
*/

const SCUM_16res = {};
SCUM_16res.pluginName = "SCUM_16res";

// Get all parameters
SCUM_16res.parameters = PluginManager.parameters(
    SCUM_16res.pluginName
);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////// Bitmap ////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// OVERWRITE of Bitmap's "initialize" function, making ALL bitmaps--even plugin-defined ones--use nearest-neighbor scaling
Bitmap.prototype.initialize = function(width, height) {
    this._canvas = null;
    this._context = null;
    this._baseTexture = null;
    this._image = null;
    this._url = "";
    this._paintOpacity = 255;
    this._smooth = false;
    this._loadListeners = [];

    // "none", "loading", "loaded", or "error"
    this._loadingState = "none";

    if (width > 0 && height > 0) {
        this._createCanvas(width, height);
    }

    /**
     * The face name of the font.
     *
     * @type string
     */
    this.fontFace = "sans-serif";

    /**
     * The size of the font in pixels.
     *
     * @type number
     */
    this.fontSize = 16;

    /**
     * Whether the font is bold.
     *
     * @type boolean
     */
    this.fontBold = false;

    /**
     * Whether the font is italic.
     *
     * @type boolean
     */
    this.fontItalic = false;

    /**
     * The color of the text in CSS format.
     *
     * @type string
     */
    this.textColor = "#ffffff";

    /**
     * The color of the outline of the text in CSS format.
     *
     * @type string
     */
    this.outlineColor = "rgba(0, 0, 0, 0.5)";

    /**
     * The width of the outline of the text.
     *
     * @type number
     */
    this.outlineWidth = 3;
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////// Window ////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Modified version of Window's "_refreshCursor" function that widens the edges of the cursor 9-slice image (for better cursor graphics)
const _Scum_Window__refreshCursor = Window.prototype._refreshCursor;
Window.prototype._refreshCursor = function() {
    const drect = this._cursorRect.clone();
    const srect = { x: 96, y: 96, width: 48, height: 48 };
    const m = 8;
    for (const child of this._cursorSprite.children) {
        child.bitmap = this._windowskin;
    }
    this._setRectPartsGeometry(this._cursorSprite, srect, drect, m);
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////// Weather ////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Modified version of Weather's "initialize" function that accounts for the lower game resolution (16x16 tiles)
const _Scum_Weather_initialize = Weather.prototype.initialize;
Weather.prototype.initialize = function() {
    PIXI.Container.call(this);

    this._width = Graphics.width/3;
    this._height = Graphics.height/3;
    this._sprites = [];

    this._createBitmaps();
    this._createDimmer();

    /**
     * The type of the weather in ["none", "rain", "storm", "snow"].
     *
     * @type string
     */
    this.type = "none";

    /**
     * The power of the weather in the range (0, 9).
     *
     * @type number
     */
    this.power = 0;

    /**
     * The origin point of the weather for scrolling.
     *
     * @type Point
     */
    this.origin = new Point();
};

//Modified version of Weather's "_createBitmaps" function that accounts for the lower game resolution (16x16 tiles)
const _Scum_Weather__createBitmaps = Weather.prototype._createBitmaps;
Weather.prototype._createBitmaps = function() {
    this._rainBitmap = new Bitmap(1, 20);
    this._rainBitmap.fillAll("white");
    this._stormBitmap = new Bitmap(2, 33);
    this._stormBitmap.fillAll("white");
    this._snowBitmap = new Bitmap(3, 3);
    this._snowBitmap.drawCircle(2, 2, 2, "white");
};

//Modified version of Weather's "_updateDimmer" function that prevents the dimmer sprite from getting too opaque at very high power weather
const _Scum_Weather__updateDimmer = Weather.prototype._updateDimmer;
Weather.prototype._updateDimmer = function() {
    if (this.power < 15) {
        this._dimmerSprite.opacity = Math.floor(this.power * 6);
    } else {
        this._dimmerSprite.opacity = Math.floor(90);
    }
};

//Modified version of Weather's "_rebornsprite" function that accounts for the lower game resolution (16x16 tiles)
const _Scum_Weather__rebornSprite = Weather.prototype._rebornSprite;
Weather.prototype._rebornSprite = function(sprite) {
    sprite.ax = Math.randomInt(Graphics.width + 33) - 33 + this.origin.x;
    sprite.ay = Math.randomInt(Graphics.height + 66) - 66 + this.origin.y;
    sprite.opacity = 160 + Math.randomInt(60);
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////// Game_CharacterBase ////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Modifed version of Game_CharacterBase's "shiftY" function that removes the 6-pixel y-offset all characters have by default
const _Scum_Game_CharacterBase_shiftY = Game_CharacterBase.prototype.shiftY;
Game_CharacterBase.prototype.shiftY = function() {
    return this.isObjectCharacter() ? 0 : 0;
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////// Scene_Base ////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Modified version of Scene_Base's "popScene" function that adds a fade to black before closing the scene
const _Scum_Scene_Base_popScene = Scene_Base.prototype.popScene;
Scene_Base.prototype.popScene = function() {
    this.startFadeOut(this.fadeSpeed()/3.5, false);
    SceneManager.pop();
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////// Scene_MenuBase ////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Modified version of Scene_MenuBase's "create" function that adds a fade in from black every time a new menu scene is pushed
const _Scum_Scene_MenuBase_create = Scene_MenuBase.prototype.create;
Scene_MenuBase.prototype.create = function() {
    Scene_Base.prototype.create.call(this);
    this.startFadeIn(this.fadeSpeed()/2, false);
    this.createBackground();
    this.updateActor();
    this.createWindowLayer();
    this.createButtons();
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////// Scene_Map ////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Modified version of Scene_Map's "start" function that adds a unique condition for the needsFadeIn() check after coming from Scene_MenuBase
const _Scum_Scene_Map_start = Scene_Map.prototype.start;
Scene_Map.prototype.start = function() {
    Scene_Message.prototype.start.call(this);
    SceneManager.clearStack();
    if (this._transfer) {
        this.fadeInForTransfer();
        this.onTransferEnd();
    } else if (this.needsFadeIn()) {
        if (SceneManager.isPreviousScene(Scene_Menu)) {
            this.startFadeIn(this.fadeSpeed()/2.5, false);
        } else {
            this.startFadeIn(this.fadeSpeed(), false);
        }
    }
    this.menuCalling = false;
};

// Modified version of Scene_Map's "needsFadeIn" function that makes the function also return true if Scene_Menu was the previous scene
const _Scum_Scene_Map_needsFadeIn = Scene_Map.prototype.needsFadeIn;
Scene_Map.prototype.needsFadeIn = function() {
    return (
        SceneManager.isPreviousScene(Scene_Battle) ||
        SceneManager.isPreviousScene(Scene_Load) ||
        SceneManager.isPreviousScene(Scene_Menu)
    );
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////// Sprite_Name ////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Modified version of Sprite_Name's "bitmapWidth" function that changes the width of Sprite_Name
const _Scum_Sprite_Name_bitmapWidth = Sprite_Name.prototype.bitmapWidth;
Sprite_Name.prototype.bitmapWidth = function() {
    return 192;
};

//Modified version of Sprite_Name's "bitmapHeight" function that changes the height of Sprite_Name
const _Scum_Sprite_Name_bitmapHeight = Sprite_Name.prototype.bitmapHeight;
Sprite_Name.prototype.bitmapHeight = function() {
    return 40;
};

// Modified version of Sprite_Name's "fontSize" function that makes the font size of the name equivalent to the system font size
Sprite_Name.prototype.fontSize = function() {
    return $gameSystem.mainFontSize();
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////// Sprite_Gauge ////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Modified version of Sprite_Gauge's "bitmapHeight" function that increases the overall height of the sprite
const _Scum_Sprite_Gauge_bitmapHeight = Sprite_Gauge.prototype.bitmapHeight;
Sprite_Gauge.prototype.bitmapHeight = function() {
    return 0; //0 for this project; this makes the gauges and text invisible
};

//Modified version of Sprite_Gauge's "gaugeHeight" function that gets rid of gauges entirely (one was still showing up in the pause menu)
const _Scum_Sprite_Gauge_gaugeHeight = Sprite_Gauge.prototype.gaugeHeight;
Sprite_Gauge.prototype.gaugeHeight = function() {
    return 0;
};

//Modified version of Sprite_Gauge's "textHeight" function that increases the height of the text of Sprite_Gauge's labels/values
const _Scum_Sprite_Gauge_textHeight = Sprite_Gauge.prototype.textHeight;
Sprite_Gauge.prototype.textHeight = function() {
    return 36;
};

//Modified version of Sprite_Gauge's "labelFontSize" function that changes the font size of Sprite_Gauge's labels (HP/MP/etc.)
const _Scum_Sprite_Gauge_labelFontSize = Sprite_Gauge.prototype.labelFontSize;
Sprite_Gauge.prototype.labelFontSize = function() {
    return $gameSystem.mainFontSize();
};

//Modified version of Sprite_Gauge's "labelOutlineWidth" function that fixes a graphical error with bitmap fonts
const _Scum_Sprite_Gauge_prototype_labelOutlineWidth = Sprite_Gauge.prototype.labelOutlineWidth;
Sprite_Gauge.prototype.labelOutlineWidth = function() {
    return 0;
};

//Modified version of Sprite_Gauge's "valueFontSize" function that changes the font size of Sprite_Gauge's values (HP amount, etc.)
const _Scum_Sprite_Gauge_valueFontSize = Sprite_Gauge.prototype.valueFontSize;
Sprite_Gauge.prototype.valueFontSize = function() {
    return $gameSystem.mainFontSize();
};



///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////// Window_ItemCategory ////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Modified version of Window_ItemCategory's "maxCols" functions that reduces the number of item categories to 3
const _Scum_Window_ItemCategory_maxCols = Window_ItemCategory.prototype.maxCols;
Window_ItemCategory.prototype.maxCols = function() {
    return 2;
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////// Window_ItemList ////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Modified version of Window_ItemList's "maxCols" function that reduces the number of item columns to 1 (no longer in use)
const _Scum_Window_ItemList_maxCols = Window_ItemList.prototype.maxCols;
Window_ItemList.prototype.maxCols = function() {
    return 2;
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////// Window_Options ////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Modified version of Window_Options's "volumeOffset" function that adjusts the volume in increments of 5 (reasonable) instead of 20 (ridiculous)
Window_Options.prototype.volumeOffset = function() {
    return 5;
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////// Window_StatusBase ////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Modified version of Window_StatusBase's "gaugeLineHeight" function that increases the line height of gauge text
const _Scum_Window_StatusBase_gaugeLineHeight = Window_StatusBase.prototype.gaugeLineHeight;
Window_StatusBase.prototype.gaugeLineHeight = function() {
    return 32;
};